//: ## ![3DaysOfSwift.com Logo](3DaysIcon46.png) Returning Values
//:
//: Functions can accept and return values.
//:
//: To return a value, a function must declare its "return type".
//:
//: Execute the code below. The function creates a `String` embedding two input parameters in a new string and returns the result.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


func greet(person: String, day: String) -> String {
    return "Hello \(person), today is \(day)."
}
let recieverOfMessage = greet(person: "Bob", day: "Tuesday") // the "caller" is this line of code
print(recieverOfMessage)


//:
//: -------------------
//:
//: ## Task:
//:
//: In the code area below, declare a global function that returns the integer `1000`.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write code here


//:
//: -------------------
//:
//: ## Task:
//:
//: In the code area below, duplcate your function, but this time accept two integer input parameters.
//:
//: Add the two inputs together and return the result.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write code here


//:
//: -------------------
//:
//: ## Task:
//:
//: In the code area below, write a new global function that accepts an `Array` of `Int` values.
//:
//: This function will add each value together and return the result.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write code here


//:
//: -------------------
//:
//: ## Task:
//:
//: In the code area below, write a new global function to accept an integer and return an `Array` of `Int` values.
//:
//: This function will divide the input by `5` and store each fifth value into an array.
//:
//: Return the input number divided into 5 values.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write code here


//:
//: -------------------
//:
//: ## Task:
//:
//: In the code area below, edit the function to split the input into `50` pieces.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


func splitIntoFive(numberToSplit: Int) -> [Double] {
    var outPutArray: [Double] = []
    
    let numberOfPieces = 5
    let fifth: Double = Double(numberToSplit) / Double(numberOfPieces)
    for index in 0..<numberOfPieces {
        outPutArray.append(fifth)
    }
    return outPutArray
}

splitIntoFive(numberToSplit: 100)
splitIntoFive(numberToSplit: 80)
splitIntoFive(numberToSplit: 60)
splitIntoFive(numberToSplit: 50)
splitIntoFive(numberToSplit: 40)
splitIntoFive(numberToSplit: 30)
splitIntoFive(numberToSplit: 20)
splitIntoFive(numberToSplit: 10)


//:
//: -------------------
//:
//: ## Task:
//:
//: Edit the code below.
//:
//: For each global function alter the type annotation of the return type to be an `Array`.
//:
//: Keeping each function to one line, return an array of values for each function.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


func generateInt() -> Int {
    100
}

func generateFloat() -> Float {
    100.0
}

func generateDouble() -> Double {
    100.0
}

func generateBool() -> Bool {
    true
}

func generateString() -> String {
    "one hundred"
}
let int = generateInt()
let float = generateFloat()
let double = generateDouble()
let bool = generateBool()
let string = generateString()


//:
//: -------------------
//:
//: Let's not forget,
//:
//: the foundational types in Swift also include `Array`, `Dictionary` and `Set`.
//:
//: The code below creates a function for each collection type.
//:
//: -------------------
//:


func generateArray() -> [String] {
    ["A", "B", "C", "D", "E"]
}
func generateDictionary() -> [String: Int] {
    ["key1": 1, "key2": 2, "key3": 3]
}
func generateSet() -> Set<Int> {
    [1, 2, 3, 4, 5]
}
let array = generateArray()
let dictionary = generateDictionary()
let set = generateSet()


//:
//: -------------------
//:
//: ## Task:
//:
//: Write a global function to record personal details and return a `Dictionary` containing `String: String` key value pairs.
//:
//: Include first name, last name and email address.
//:
//: Execute this function, let it generate a new dictionary and iterate over each key-value pair to print each value to the console.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:
